/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * Export symbols for module (mmfslinux)
 *
 * Define new global variables with GPFS_EXPORT_SYMBOL(varname).
 * Define new functions with GPFS_EXPORT_FUNC(varname).
 *
 * The latter will automatically spit out a generic function
 * prototype. The prototype format doesn't matter here, but
 * it is important to let the compiler know that something
 * is really a function (or else incorrect code is spewed out
 * on IA64 for the relocation entry which trips up insmod;
 * the i386 platform doesn't have this feature).
 *
 * NOTE: C++ function names / methods are generally mangled and
 * you need to use the managled symbol name. The mangled name can
 * be found by scanning the appropriate object file w/
 * "objdump --syms <file> | grep <original symbol name>", or just
 * try to load the module and shove the undefined reference names
 * in here.
 * These mangled names seem to be architecture independant so far.
 *
 *
 * $Id: gpl-ksyms.c,v 1.88 2002/02/11 08:02:22 mcnabb Exp $
 *
 * $Log: gpl-ksyms.c,v $
 * Revision 1.88  2002/02/11 08:02:22  mcnabb
 * Incorrect comment begin at endif
 *
 * Revision 1.87  2001/11/07 16:50:14  dcraft
 * Defect 353738: Manage a ref count on the mmfs module for every mount.
 * An additionaly ref will be on the module as long as the daemon is
 * alive.  We're doing this because if the daemon dies with mount
 * points still active, the mmfs module can be unloaded by rmmod but
 * the code doesn't successfully clean everything up.  Thus the rmmod
 * needs to be blocked from the unload attempt by ref counts.
 *
 * Revision 1.86  2001/10/24 18:13:09  dcraft
 * Defect 352112: Be more systematic about kproc startup and end.  Let
 * keventd spawn the kernel threads in linux so we can signal him to
 * reap them.
 *
 * Revision 1.85  2001/10/11 14:04:19  gjertsen
 * Provide support for 64-bit mutex lockword for IA64 (LOCKWORD64).
 *
 * Revision 1.84  2001/09/25 18:06:48  gjertsen
 * Remove obsolete IA64 hack.
 *
 * Revision 1.83  2001/09/22 20:08:01  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.82  2001/09/21 22:54:31  yuri
 * Remove core dump code.
 *
 * Revision 1.81  2001/09/20 21:45:43  wyllie
 * Add call to determine if a cxiBlockingMutex_t has any threads waiting
 * for it
 *
 * Revision 1.80  2001/09/18 06:07:45  schmuck
 * Get rid of some compiler warnings.
 *
 * Revision 1.79  2001/09/12 23:54:36  eshel
 * Reanme cxi_schedule() to cxiYield()
 *
 * Revision 1.78  2001/09/12 22:20:28  eshel
 * add cxi_schedule() to call schedule()
 *
 * Revision 1.77  2001/08/23 22:55:29  manoj
 * Define an interface to allow a machine SID to be registered for access control.
 *
 * Revision 1.76  2001/08/21 14:48:17  mroberts
 *
 * Rename cxiIsSambaThread to cxiIsSambaOrLockdThread.
 * Create cxiIsSambaThread that tests only for smbd and not lockd.
 *
 * Revision 1.75  2001/08/21 01:56:27  tee
 * Make AIX and Linux versions of buf queue handling be the same.
 *
 * Revision 1.74  2001/08/18 02:11:30  tee
 * Improve matching between AIX and Linux mmap code to prepare for source file
 * merge.
 *
 * Revision 1.73  2001/08/16 01:26:24  tee
 * Fix dynamic mmap kproc starting and stopping on Linux.  Don't start processes
 * that only live for the duration of a page fault.  Use the daemon startup
 * thread as a master controller for the kprocs, which will wait on them when
 * they exit to keep them from becoming zombies.
 *
 * Revision 1.72  2001/08/10 22:33:03  tee
 * Declare functions with correct argument types to avoid unnecessary casting.
 * Cosmetic changes to make AIX and Linux mmap code more similar.
 *
 * Revision 1.71  2001/08/10 00:41:19  wyllie
 * Use lock indices instead of lock numbers when calling cxiBlockingMutexInit,
 * to simplify statistics gathering.  Add call to reset or read statistics
 * for cxiBlockingButex_ts from the kernel.
 *
 * Revision 1.70  2001/08/06 23:36:02  wyllie
 * Count number of acquires and contention for cxiBlockingMutex_ts.
 * Add routine to determine if the current process holds the kernel lock.
 *
 * Revision 1.69  2001/08/04 00:42:26  tee
 * Remove LINUX_MMAP ifdefs
 *
 * Revision 1.68  2001/07/19 23:24:58  dcraft
 * Modified linux trace to allow non blocking trace record
 * writes (format is TRACE?N).  New gpfs swapd process created
 * which is responsible for reclaiming inodes (5 percent every
 * time it runs).  Marked all our inodes so that they would be
 * ignored by linux kswapd.  Added "unused" inode to inode
 * cache that could be used as a signal that linux kswapd is
 * running and kick off gpfs swapd.  Added means to ignore attempts
 * to kill mmfsd by kswapd if the system gets low on memory.
 * All done in an attempt to avoid kswapd premature wakeup on simple
 * locks and mutexes.
 *
 * Revision 1.67  2001/07/13 19:54:45  wyllie
 * Get PAGE_OFFSET by asking the mmfslinux_... kernel module rather than
 * compiling the constant into proprietary code.  Rename constants needed to
 * determine the GPFS memory map and export them to non-proprietary files.
 *
 * Revision 1.66  2001/07/11 03:56:56  manoj
 * Define gpfsCheckNTAccess to check if NT caller has access to a file through
 * individual NT permission bits (other that standard rwx which can be checked by
 * access() call).
 *
 * Revision 1.65  2001/07/10 12:06:26  jpalmer
 * Add function to allow SMB Open and FCNTL tokens to be moved from one system to
 * another in response to the NAS load balancer moving the users.  Add the
 * external interface to provide a lock clamping function that will block new
 * locks during the time NFS is recovering its FCNTL and File locks.
 *
 * Revision 1.64  2001/07/02 18:00:25  eshel
 * Initialize gpfsNode hash table based on (fileCacheLimit + statCacheLimit).
 *
 * Revision 1.63  2001/06/06 21:55:35  wyllie
 * Change the way NFSData objects are timed out.  Instead of using watchdog
 * timers that enqueue NFSData objects at interrupt level for later
 * processing by the NFS watchdog kernel process, just let the watchdog
 * process wake up periodically and examine its LRU list of NFSData objects
 * to decide which should be closed.  This fixes a bug on Linux that shows
 * up as the assert "nfsP->nextWatchP == NFS_WATCH_NOT_QUEUED" under high
 * load.  This also allows deleting a bunch of cxiXXX interfaces dealing
 * with watchdog timers.
 *
 * Revision 1.62  2001/06/01 18:51:31  gjertsen
 * Introduce macros for intentional conversion between pointers
 * and 32-bit integers so that needless compiler warnings are
 * filtered out while important warnings are now more apparent.
 *
 * Revision 1.61  2001/05/12 18:38:26  schmuck
 * Fix problem with NFS returning spurious errors under load.
 *
 * Revision 1.60  2001/05/09 23:05:11  eshel
 * Use malloc for gpfsNode if it is to big for the linux inode.
 *
 * Revision 1.59  2001/05/03 20:50:41  radhak
 * Defect 338936:
 * Linux mmap: PagerKproc::adjustKprocs:
 * Need to get rid of kernel thread zombies
 *
 * Revision 1.58  2001/05/02 20:45:06  eshel
 * Make sure the all OS nodes are invalidated before auto remount.
 *
 * Revision 1.57  2001/05/02 00:21:23  schmuck
 * Fix another problem found by tortureDir test on Linux:
 * On lookup and create, instantiate the dcache entry while holding the
 * inode lock, or, in case of a negative dcache entry, the directory lock.
 * This closes a window where a token revoke could clear the
 * CO_VFS_REFERENCE flag without invalidating the dcache entry.
 * It also eliminates the need for a d_revalidate operation.
 *
 * Revision 1.56  2001/04/30 23:30:53  wyllie
 * Use proper macro to export function names
 *
 * Revision 1.55  2001/04/27 20:23:35  eshel
 * export cxiIsGPFSThread
 *
 * Revision 1.54  2001/04/24 23:11:31  eshel
 * Add the KXIVO_DESTROY flag to tell kxInvalidateOSNode() to set i_nlink in the
 * linux inode to zero on from MNodeToken::token_revoke() with the
 * CTM_A_BEING_DESTROYED on. The file is being destroyed.
 *
 * Revision 1.53  2001/04/24 18:12:58  wyllie
 * Move handle of the trace file out of the shared segment.
 *
 * Revision 1.52  2001/04/23 22:18:19  jpalmer
 * Fix oplock hang by locating open file for ftruncInternal
 *
 * Revision 1.51  2001/04/21 01:04:24  wyllie
 * Use new infrastructure for allocating and making accessible memory shared
 * between the kernel and the daemon.
 *
 * Revision 1.50  2001/04/19 20:50:19  wyllie
 * Checkpoint partial code to dynamically grow the memory shared between the
 * kernel and the GPFS daemon
 *
 * Revision 1.49  2001/04/13 21:04:10  gjertsen
 * Tweak macro to get rid of annoying cpp messages with gnu compiler.
 *
 * Revision 1.48  2001/04/10 21:10:46  wyllie
 * Convert cxiIOBuffer.C from C++ to C.
 *
 * Revision 1.47  2001/04/06 21:00:15  gjertsen
 * Selectively screen out regular sync calls from kupdate.
 *
 * Revision 1.46  2001/04/05 13:31:07  gjertsen
 * Continue C++ to C conversion with manual C++2C utility.
 * Changes primarily for vfs stat stuff.
 *
 * Revision 1.45  2001/04/04 22:29:04  eshel
 * add cxiUpdateInode() to keep linux inode up to date
 *
 * Revision 1.44  2001/04/02 14:33:11  dixonbp
 * Convert mmap.C to mmap.c
 *
 * Revision 1.43  2001/03/30 21:36:09  dixonbp
 * Convert kx.C to kx.c
 *
 * Revision 1.42  2001/03/29 18:26:40  dixonbp
 * Convert super.C to super.c
 *
 * Revision 1.41  2001/03/28 08:50:15  manoj
 * Support for DOS attributes (NSS only). Define gpfs_ops GetDosAttr and
 * SetDosAttr for the purpose.
 *
 * Revision 1.40  2001/03/27 17:13:15  eshel
 * remove unused code
 *
 * Revision 1.39  2001/03/26 18:29:56  dcraft
 * Update inode attributes in OS node layer via callback to cxiSetOSNode
 * (previous setInode).  The attributes are now updated during kSFSGetattr()
 * while the lock is held to ensure validity.
 *
 * Revision 1.38  2001/03/14 00:36:32  eshel
 * add cxiSetInode() to call setInode()
 *
 * Revision 1.37  2001/03/09 18:10:50  schmuck
 * More SMB oplock code.
 *
 * Revision 1.36  2001/03/09 16:44:18  jpalmer
 * SMB Locking - remove old dfs Interops functions
 *
 * Revision 1.35  2001/03/07 00:50:53  eshel
 * remove unused code
 *
 * Revision 1.34  2001/03/05 23:28:10  dcraft
 * Modify inode and gpfsNode reference management.  Inode is now acquired
 * during gpfsNode creation and must be released via cxiPutOSNode().
 * (documented in gpfs database).  Add "mmfsadm dump vnodes" for producing
 * trace info on all held inodes.
 *
 * Revision 1.33  2001/03/02 22:46:24  jpalmer
 * SMB Locking function: user communications
 *
 * Revision 1.32  2001/03/01 20:44:22  radhak
 * Need serialization between nopage and mmap flush.
 * Also, always get page table lock while holding page lock.
 *
 * Revision 1.31  2001/02/15 21:57:31  manoj
 * Support for NSS (NAS Security System). The filesystem stores NT-style ACLs and
 * uses NSS for access control and permission checking. All NSS code should be
 * #ifdef'ed by CONFIG_NSS.
 *
 * Revision 1.30  2001/02/08 19:45:54  gjertsen
 * Add kxMadvise kernel extension
 *
 * Revision 1.29  2001/02/08 18:03:39  schmuck
 * Tweak fast path through gpfs_i_permission for files that don't have
 * extended acls: instead of doing the check in gpfs_i_permission,
 * set inode_operations::permission to NULL so Linux will do the check
 * without invoking gpfs_i_permission.
 * No functional change.
 *
 * Revision 1.28  2001/01/28 20:42:52  dcraft
 * Invoke lcrash for kernel thread tracebacks.  Mod kxDumpTraceBack()
 * to allow a file name for output.  Normal ksymoops is backup if
 * lcrash isn't present.
 *
 * Revision 1.27  2001/01/25 21:56:54  gjertsen
 * Put errno symbol back into ODE build.
 *
 * Revision 1.26  2001/01/25 18:40:53  eshel
 * Add code to support gpfs_iwrite() gpfs_iread() gpfs_ireaddir().
 *
 * Revision 1.25  2001/01/25 18:35:52  wyllie
 * Rename panic to cxiPanic, which is implemented as an exported entry point of
 * the mmfslinux module on Linux, and as a macro that invokes panic on AIX.
 *
 * Revision 1.24  2001/01/12 02:55:54  eshel
 * Add code for read by inode.
 *
 * Revision 1.23  2001/01/09 19:32:43  michail
 * Updates to support buidling GPFS for Linux in ODE
 *
 * Revision 1.22  2000/12/15 13:56:40  gjertsen
 * Clean up documentation.
 *
 * Revision 1.21  2000/12/13 18:35:00  wyllie
 * Convert more Simple_locks to cxiBlockingMutex_ts.  Implement
 * cxiBlockingMutexHeldByCaller() instead of lock_mine().
 *
 * Revision 1.20  2000/12/12 16:33:15  wyllie
 * Change e_sleep_thread and cxiEventWakeup... to cxiWaitEventWait and
 * cxiWaitEventSignal/Broadcast.
 *
 * Revision 1.19  2000/12/09 20:33:36  schmuck
 * Instead of setting/checking flags to invalidate/revalidate dcache entries,
 * simply set dentry::d_ops to point to different dentry_operations tables:
 * one where the d_revalidate field is NULL (means the dentry is valid),
 * and one where d_revalidate points at a function that always returns false
 * (means the dentry is invalid).
 *
 * Revision 1.18  2000/12/08 22:16:04  schmuck
 * Add a call to invalidate negative dcache entries when a directory
 * byte-range token is relinquished.  This allows gpfs_d_revalidate
 * to return the correct answer for negative dcache entries, avoiding
 * an extra call to lookup.
 *
 * Revision 1.17  2000/12/08 18:35:11  wyllie
 * Add cxiBlockingMutex_t type and operations that act on it.  Uses simple_lock
 * on AIX and binary semaphores on Linux.
 *
 * Revision 1.16  2000/12/06 16:52:41  dcraft
 * write inline versions of cxiString functions for linux kernel
 *
 * Revision 1.15  2000/12/03 01:48:09  radhak
 * LINUX_MMAP: mmap flush
 *
 * Revision 1.14  2000/12/01 02:10:58  schmuck
 * Instead of assigning NULL function pointers when initializing or resetting the
 * gpfs_operations table, have it point to a dummy function that returns ENOSYS.
 * This avoids having to check for NULL before each call.
 *
 * Revision 1.13  2000/11/17 15:21:33  gjertsen
 * Rename or make static several functions.
 * Minor fix for gpl-ksyms.c when MODULES isn't used.
 *
 * Revision 1.12  2000/11/17 14:28:04  radhak
 * Removed relMmapCredP.
 *
 * Revision 1.11  2000/11/10 22:45:50  radhak
 * Removed all mmap printks and added one more function to symbol table.
 *
 * Revision 1.10  2000/11/07 17:02:51  dcraft
 * kxResetKX was removed and thus export of it will produce unresolved
 * symbol in mmfslinux.
 *
 * Revision 1.9  2000/11/07 00:16:22  eshel
 * Add code to support remount.
 *
 * Revision 1.8  2000/11/06 19:56:12  gjertsen
 * Linux code cleanup and put in build safeguards.
 *
 * Revision 1.7  2000/11/03 19:26:29  wyllie
 * Improve cache performance of tracing on i386 under FAR_TRACE ifdef.  Also
 * make trace flags be chars instead of ints to use less D-cache space.
 *
 * Revision 1.6  2000/11/03 14:23:26  gjertsen
 * Omit my_printk export for IA64.
 *
 * Revision 1.5  2000/11/02 17:30:08  eshel
 * export my_printk
 *
 * Revision 1.4  2000/11/01 22:40:32  tee
 * Add exported symbols for mmap
 *
 * Revision 1.3  2000/11/01 21:46:03  dcraft
 * kxResetKX needs to be exported otherwise mmfs gets unresolved symbol
 * For some reason rmmod of mmfslinux is causing a kernel oops.
 *
 * Revision 1.2  2000/10/31  15:41:56  gjertsen
 * Account for atomic operations in cxi layer.
 *
 * Revision 1.1  2000/10/26  20:52:34  gjertsen
 * Purge out ugly USE_CWRAPPERS and export module symbols explicitly
 * as the default (in IA64 safe manner).
 *
 *
 */

#include <linux/version.h>
#include <linux/module.h>
#define GPFS_GPL

/* ************************************************************* */
/* Various kludge definitions that are are needed with C++ code.
/* ************************************************************* */

#ifdef MODULE

extern int printk(const char * fmt, ...);
void terminate__Fv() { printk("??? terminate() called ???\n"); };

int errno = 0;

#ifdef GPFS_ARCH_IA64
void __builtin_delete() { printk("??? __builtin_delete() called ???\n"); };
void __throw() { printk("??? __throw() called ???\n"); };
#endif /* GPFS_ARCH_IA64 */

#endif /* MODULE */

#ifdef GPFS_ARCH_IA64
int __ia64_personality_v1 = 0;
#endif /* GPFS_ARCH_IA64 */

/* ********************** */
/* Export symbols section */
/* ********************** */

#if defined(MODULE) && defined(GPFS_EXPORT_KSYMS)

/* Use GPFS_EXPORT_SYMBOL for exporting a variable */
/* Use GPFS_EXPORT_FUNC for exporting a function */
#define GPFS_EXPORT_SYMBOL(VAR) extern VAR; EXPORT_SYMBOL_NOVERS(VAR);
#define GPFS_EXPORT_FUNC(FNAME) extern void FNAME (); \
                                EXPORT_SYMBOL_NOVERS(FNAME);
/* Only use native EXPORT_SYMBOL_NOVERS when you need to explicitly
 * define something or initialize it here. */

/* cxiIOBuffer.C */
GPFS_EXPORT_FUNC(cxiAttachIOBuffer);
GPFS_EXPORT_FUNC(cxiDetachIOBuffer);
GPFS_EXPORT_FUNC(cxiUXfer);
GPFS_EXPORT_FUNC(cxiKXfer);
GPFS_EXPORT_FUNC(cxiKZero);
GPFS_EXPORT_FUNC(cxiMapDiscontiguousRW);
GPFS_EXPORT_FUNC(cxiUnmapDiscontiguousRW);
GPFS_EXPORT_FUNC(cxiMapContiguousRO);
GPFS_EXPORT_FUNC(cxiUnmapContiguousRO);
GPFS_EXPORT_FUNC(cxiKDoIO);
GPFS_EXPORT_FUNC(cxiKibdPin);
GPFS_EXPORT_FUNC(cxiKibdUnpin);
GPFS_EXPORT_FUNC(cxiKibdUnpinAll);
GPFS_EXPORT_FUNC(cxiKibdSplit);
GPFS_EXPORT_FUNC(cxiKibdMerge);

/* cxiVFSStats.C */
GPFS_EXPORT_SYMBOL(vfsStats);
GPFS_EXPORT_FUNC(VFSStatPoint_begin);
GPFS_EXPORT_FUNC(VFSStatPoint_end);
#ifdef KCSTRACE
GPFS_EXPORT_FUNC(cxiKcsTraceInfo);
#endif

/* cxiIOBuffer.C */
GPFS_EXPORT_FUNC(GetDiskInfoX);

/* cxiSystem.C */
/* cxiSystem.h */
GPFS_EXPORT_FUNC(cxiFcntlUnblock);
GPFS_EXPORT_FUNC(cxiFcntlLock);
GPFS_EXPORT_FUNC(cxiFcntlReset);
GPFS_EXPORT_FUNC(cxiTrace);
GPFS_EXPORT_FUNC(cxiFlockToVFS);
GPFS_EXPORT_FUNC(cxiVFSToFlock);
GPFS_EXPORT_FUNC(cxiCheckTypes);
GPFS_EXPORT_FUNC(cxiOpenNFS);
GPFS_EXPORT_FUNC(cxiCloseNFS);
GPFS_EXPORT_FUNC(cxiGetNfsP);
GPFS_EXPORT_FUNC(cxiSetNfsP);
GPFS_EXPORT_FUNC(cxiGetCnP);
GPFS_EXPORT_FUNC(cxiGetPvP);
GPFS_EXPORT_FUNC(cxiGNPtoVP);
GPFS_EXPORT_FUNC(cxiSetProcessGroup);
GPFS_EXPORT_FUNC(cxiSetProcessName);
GPFS_EXPORT_FUNC(cxiStartKProc);
GPFS_EXPORT_FUNC(cxiStopKProc);
GPFS_EXPORT_FUNC(cxiSleep);
GPFS_EXPORT_FUNC(cxiPanic);
GPFS_EXPORT_FUNC(cxiGetKernelBoundary);
GPFS_EXPORT_FUNC(cxiHoldsBKL);

/* cxiSystem-plat.h */
GPFS_EXPORT_FUNC(cxiIsGPFSThread);
GPFS_EXPORT_FUNC(cxiGetThreadId);
GPFS_EXPORT_FUNC(cxiGetFcntlOwner);
GPFS_EXPORT_FUNC(cxiUiomove);
GPFS_EXPORT_FUNC(cxiMallocPinned);
GPFS_EXPORT_FUNC(cxiFreePinned);
GPFS_EXPORT_FUNC(cxiBigMalloc);
GPFS_EXPORT_FUNC(cxiBigFree);
GPFS_EXPORT_FUNC(cxiCopyIn);
GPFS_EXPORT_FUNC(cxiCopyOut);
GPFS_EXPORT_FUNC(cxiCopyInstr);
GPFS_EXPORT_FUNC(cxiStackAddrToThreadId);
GPFS_EXPORT_FUNC(cxiThreadPtrToThreadId);
GPFS_EXPORT_FUNC(cxiLowPagingNotify);
GPFS_EXPORT_FUNC(cxiIsSuperUser);
GPFS_EXPORT_FUNC(cxiWaitEventHasWaiters);
GPFS_EXPORT_FUNC(cxiWaitEventInit);
GPFS_EXPORT_FUNC(cxiWaitEventWakeup);
GPFS_EXPORT_FUNC(cxiWaitEventWakeupOne);
GPFS_EXPORT_FUNC(cxiWaitEventWakeupResult);
GPFS_EXPORT_FUNC(e_sleep_thread);
GPFS_EXPORT_FUNC(lock_alloc);
GPFS_EXPORT_FUNC(simple_lock_init);
GPFS_EXPORT_FUNC(lock_free);
GPFS_EXPORT_FUNC(simple_lock);
GPFS_EXPORT_FUNC(simple_unlock);
GPFS_EXPORT_FUNC(unlock_enable);
GPFS_EXPORT_FUNC(disable_lock);
GPFS_EXPORT_FUNC(cxiGetTOD);
GPFS_EXPORT_FUNC(cxiIsNFSThread);
GPFS_EXPORT_FUNC(cxiIsKupdateThread);
GPFS_EXPORT_FUNC(cxiBlockingMutexInit);
GPFS_EXPORT_FUNC(cxiBlockingMutexAcquire);
GPFS_EXPORT_FUNC(cxiBlockingMutexRelease);
GPFS_EXPORT_FUNC(cxiBlockingMutexTerm);
GPFS_EXPORT_FUNC(cxiBlockingMutexHeldByCaller);
GPFS_EXPORT_FUNC(cxiBlockingMutexHasWaiters);
GPFS_EXPORT_FUNC(cxiYield);
#ifdef INSTRUMENT_LOCKS
GPFS_EXPORT_FUNC(BlockingMutexStatsTable);
#endif
GPFS_EXPORT_FUNC(cxiWaitEventWait);
GPFS_EXPORT_FUNC(cxiWaitEventSignal);
GPFS_EXPORT_FUNC(cxiWaitEventBroadcast);
GPFS_EXPORT_FUNC(cxiWaitEventBroadcastRC);
/* misc stuff */
GPFS_EXPORT_FUNC(socket_aio_dequeue);
GPFS_EXPORT_FUNC(getpid);
GPFS_EXPORT_FUNC(memset);
GPFS_EXPORT_FUNC(cxiInvalidateDCacheEntry);
GPFS_EXPORT_FUNC(cxiInvalidateDCacheEntryNoPrune);
GPFS_EXPORT_FUNC(cxiInvalidateNegDCacheEntries);
GPFS_EXPORT_FUNC(cxiInvalidatePerm);
GPFS_EXPORT_FUNC(cxiUpdateInode);
/* misc trace stuff */
GPFS_EXPORT_SYMBOL(TraceFlagsP);

#ifdef CONFIG_NSS
/* nss stuff */
GPFS_EXPORT_FUNC(cxiIsValidPID);
GPFS_EXPORT_FUNC(cxiIsCapable);
GPFS_EXPORT_FUNC(cxiGetGroupList);
GPFS_EXPORT_FUNC(cxiGetFSUid);
GPFS_EXPORT_FUNC(cxiGetFSGid);
GPFS_EXPORT_FUNC(cxiGetGroupListPID);
GPFS_EXPORT_FUNC(cxiSetGroupListPID);
GPFS_EXPORT_FUNC(cxiSetPAG);
GPFS_EXPORT_FUNC(kxGetDosAttr);
GPFS_EXPORT_FUNC(kxPutDosAttr);
GPFS_EXPORT_FUNC(kxCheckNTAccess);
GPFS_EXPORT_FUNC(kxSetMachineSID);
#endif

#ifdef SMB_LOCKS
GPFS_EXPORT_FUNC(cxiIsSambaOrLockdThread);
GPFS_EXPORT_FUNC(cxiSMBOpenLockControl);
GPFS_EXPORT_FUNC(setSMBOplock);
GPFS_EXPORT_FUNC(breakSMBOplock);
GPFS_EXPORT_FUNC(cxiCheckOpen);
GPFS_EXPORT_FUNC(kxClampLocks);
GPFS_EXPORT_FUNC(kxUnClampLocks);
#endif

#ifdef CCL
GPFS_EXPORT_FUNC(cxiIsSambaThread);
#endif

/* ss.c */
GPFS_EXPORT_SYMBOL(ss_ioctl_op);
GPFS_EXPORT_FUNC(cxiCalcMaxSharedKernelMemory);
GPFS_EXPORT_FUNC(cxiAllocSharedKernelMemory);
GPFS_EXPORT_FUNC(cxiMapAllSharedKernelMemory);
GPFS_EXPORT_FUNC(cxiDeallocAllSharedKernelMemory);

/* kx.c */
GPFS_EXPORT_FUNC(kxGetACL);
GPFS_EXPORT_FUNC(kxPutACL);
GPFS_EXPORT_FUNC(tsstat);
GPFS_EXPORT_FUNC(tsfstat);
GPFS_EXPORT_FUNC(tsfattr);
GPFS_EXPORT_FUNC(tsattr);
GPFS_EXPORT_FUNC(kxPoll);
GPFS_EXPORT_FUNC(kxRegisterCleanup);
GPFS_EXPORT_FUNC(cxiGetPrivVfsP);
GPFS_EXPORT_FUNC(kxMadvise);

/* super.c */
GPFS_EXPORT_FUNC(cxiSetMountInfo);
GPFS_EXPORT_FUNC(cxiReactivateOSNode);
GPFS_EXPORT_FUNC(cxiNewOSNode);
GPFS_EXPORT_FUNC(cxiFreeOSNode);
GPFS_EXPORT_FUNC(cxiDeleteMmap);
GPFS_EXPORT_FUNC(cxiReinitOSNode);
GPFS_EXPORT_FUNC(cxiFindOSNode);
GPFS_EXPORT_FUNC(cxiRefOSNode);
GPFS_EXPORT_FUNC(cxiInactiveOSNode);
GPFS_EXPORT_FUNC(cxiPutOSNode);
GPFS_EXPORT_FUNC(cxiDestroyOSNode);
GPFS_EXPORT_FUNC(cxiSetOSNodeType);
GPFS_EXPORT_FUNC(cxiSetOSNode);
GPFS_EXPORT_FUNC(cxiCanUncacheOSNode);
GPFS_EXPORT_FUNC(cxiDumpOSNode);
GPFS_EXPORT_FUNC(cxiAddOSNode);
GPFS_EXPORT_FUNC(cxiAddOSNodeUnused);
GPFS_EXPORT_FUNC(cxiRemoveOSNodeUnused);

/* gplInit.C */
GPFS_EXPORT_SYMBOL(gpfs_ops);
GPFS_EXPORT_FUNC(gpfs_init);
GPFS_EXPORT_FUNC(cxiExportModuleStruct);
GPFS_EXPORT_FUNC(cxiIncModuleCounter);
GPFS_EXPORT_FUNC(gpfs_clean);
GPFS_EXPORT_FUNC(reset_gpfs_operations);

/* mmap.c */
GPFS_EXPORT_SYMBOL(kprocsRunning);
GPFS_EXPORT_SYMBOL(mmapAbort);
GPFS_EXPORT_SYMBOL(pagerEventWord);
GPFS_EXPORT_SYMBOL(FreeEventWord);
GPFS_EXPORT_SYMBOL(pagerLock);
GPFS_EXPORT_SYMBOL(mmapFlushLockWord);
GPFS_EXPORT_SYMBOL(mmapFlushEventWord);
GPFS_EXPORT_FUNC(Createpagrkproc);
GPFS_EXPORT_FUNC(IoDone);
GPFS_EXPORT_FUNC(MMFlushRange);
GPFS_EXPORT_FUNC(RegisterPagerBackEnd);
GPFS_EXPORT_FUNC(UnregisterPagerBackEnd);
GPFS_EXPORT_FUNC(getFilePos);
GPFS_EXPORT_FUNC(getHeadQueue);
GPFS_EXPORT_FUNC(getVp);
GPFS_EXPORT_FUNC(waitingForFreeEntries);
GPFS_EXPORT_FUNC(wakeKprocMaster);


/* ****************************************************** */
/* Various kludges that are are needed with C++ code.
/* ****************************************************** */

/* General C++ kludges */
EXPORT_SYMBOL_NOVERS(terminate__Fv);
EXPORT_SYMBOL_NOVERS(errno);

/* Misc ia64 kludges */
#ifdef GPFS_ARCH_IA64
EXPORT_SYMBOL_NOVERS(__ia64_personality_v1);
EXPORT_SYMBOL_NOVERS(__builtin_delete);
EXPORT_SYMBOL_NOVERS(__throw);
#endif /* GPFS_ARCH_IA64 */

#endif /* MODULE && GPFS_EXPORT_KSYMS */
